package gov.va.vinci.dart.json;


public class DataSourceView implements Comparable {

	private int id;
	private String name;
	private String domainName;
	private String description;
	private String fields;
	private String infoSite;
	private int sortOrder = 0;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getFields() {
		return fields;
	}

	public void setFields(String fields) {
		this.fields = fields;
	}

	public String getInfoSite() {
		return infoSite;
	}

	public void setInfoSite(String infoSite) {
		this.infoSite = infoSite;
	}
	
	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}
	
	
	@Override 
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof DataSourceView) == false) {
			return false;
		}
		
		return this.getId() == ((DataSourceView)obj).getId();	//compare the id column for the DataSource
	}
	
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if ((o instanceof DataSourceView) == false) {
			return -1;
		}
		
		DataSourceView obj2 = (DataSourceView)o;

		// sort by sortOrder
		if (this.getSortOrder() == obj2.getSortOrder()) {
			return 0;
		}
		
		return this.getSortOrder() < obj2.getSortOrder() ? -1 : 1;
	}
	
}
